/*
 *	Emissive Pass
 */
// Options:
//   optTextured : true the material has a emissive map. False, renders black.
float4x4 matViewProjMatrix;
float4x4 matWorldMatrix;

struct VS_INPUT{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
};


struct VS_OUTPUT{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
};


VS_OUTPUT vs_emissive(VS_INPUT input){
	VS_OUTPUT Out = (VS_OUTPUT)0;
	input.position = mul(input.position, matWorldMatrix);
	Out.position = mul(input.position, matViewProjMatrix);
	Out.tex = input.tex;
	return Out;
}


sampler diffuseMap;
sampler emissiveMap;


float4 ps_emissive(float2 tex: TEXCOORD):COLOR0{
	float alpha = tex2D(diffuseMap, tex).a;
	if(optTextured)
		return float4(tex2D(emissiveMap, tex).rgb, alpha);
	else
		return float4(0,0,0,alpha);
	//	return tex2D(diffuseMap, tex);
}



/*
 *	Glow
 */


float blur = 0.035;
bool hdir = false;
float2 offset = float2(0,0);	// offset to center the glow to the image

static const float mult = 1.0f/5.0f;

struct VS_GLOWIN{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
};

struct VS_GLOWOUT 
{
	float4 Pos: POSITION;

	float2 tex1: TEXCOORD0;		//centro

	float2 tex2: TEXCOORD1;		//lado 1
	float2 tex3: TEXCOORD2;
	float2 tex4: TEXCOORD3;
	float2 tex5: TEXCOORD4;
	float2 tex6: TEXCOORD5;
};

VS_GLOWOUT vs_glow(VS_GLOWIN input)
{
	VS_GLOWOUT Out = (VS_GLOWOUT)0;

	Out.Pos = input.position;

	if(hdir){

		Out.tex1 = input.tex + offset;

		Out.tex2 = float2(blur*mult*1,0) + offset;
		Out.tex3 = float2(blur*mult*2,0) + offset;
		Out.tex4 = float2(blur*mult*3,0) + offset;
		Out.tex5 = float2(blur*mult*4,0) + offset;
		Out.tex6 = float2(blur*mult*5,0) + offset;

	}
	else{

		Out.tex1 = input.tex + offset;

		Out.tex2 = float2(0,blur*mult*1) + offset;
		Out.tex3 = float2(0,blur*mult*2) + offset;
		Out.tex4 = float2(0,blur*mult*3) + offset;
		Out.tex5 = float2(0,blur*mult*4) + offset;
		Out.tex6 = float2(0,blur*mult*5) + offset;
	}

	return Out;
}


sampler glowMap;
float intensity = 1.1;

struct PS_GLOWIN
{
	float2 tex1: TEXCOORD0;		//centro

	float2 tex2: TEXCOORD1;		//lado 1
	float2 tex3: TEXCOORD2;
	float2 tex4: TEXCOORD3;
	float2 tex5: TEXCOORD4;
	float2 tex6: TEXCOORD5;
};

float4 ps_glow(PS_GLOWIN input) : COLOR0
{
	float4 color = 0;
	color += tex2D(glowMap, input.tex1)*5.0f;

	if(optHightQuality){
		color += tex2D(glowMap, input.tex1+input.tex2 )*4.6f;
		color += tex2D(glowMap, input.tex1+input.tex3 )*3.8f;
		color += tex2D(glowMap, input.tex1+input.tex4 )*2.8f;
		color += tex2D(glowMap, input.tex1+input.tex5 )*1.7f;
		color += tex2D(glowMap, input.tex1+input.tex6 )*1.0f;

		color += tex2D(glowMap, input.tex1-input.tex2 )*4.6f;
		color += tex2D(glowMap, input.tex1-input.tex3 )*3.8f;
		color += tex2D(glowMap, input.tex1-input.tex4 )*2.8f;
		color += tex2D(glowMap, input.tex1-input.tex5 )*1.7f;
		color += tex2D(glowMap, input.tex1-input.tex6 )*1.0f;

		color /= 31.8;
	}
	else{
		color += tex2D(glowMap, input.tex1+input.tex3 )*3.8f;
		color += tex2D(glowMap, input.tex1+input.tex6 )*1.0f;

		color += tex2D(glowMap, input.tex1-input.tex3 )*3.8f;
		color += tex2D(glowMap, input.tex1-input.tex6 )*1.0f;

		color /= 14.6;
	}

	return color*intensity;
}


struct VS_INQUAD{
	float4 position: POSITION;
	float4 color: COLOR0;
};

struct VS_OUTQUAD{
	float4 position: POSITION;
	float4 color: COLOR0;
};


VS_OUTQUAD vs_quad(VS_INQUAD input){
	VS_OUTQUAD Out = (VS_OUTQUAD)0;
	Out.position = input.position;
	Out.color = input.color;
	return Out;
}


float4 ps_quad(float4 color:COLOR0):COLOR0{
	return color;
}